/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#import <Cocoa/Cocoa.h>
#import <CoreVideo/CoreVideo.h>

#include "DeckLinkAPI.h"

#include <map>

typedef std::map<uint64_t, CVPixelBufferRef> frame_map_t;

@interface OpenGLPreview : NSOpenGLView
{
	NSRecursiveLock*			m_lock;
	CVDisplayLinkRef			m_displayLink;
	CVImageBufferRef			m_currentFrame;
	BOOL						m_needsReshape;
	
	GLuint						m_textureId;
	int							m_textureWidth;
	int							m_textureHeight;		


	// The decompressed frame map: we queue frames here as they arrive from the
	// decompression session.  They will arrive out of order if the clip
	// contains B-frames, so a sorted container is used to allow in-order
	// retrieval by display time.
	NSRecursiveLock*			m_frameMapLock;
	uint32_t					m_frameMapTimeScale;
	uint64_t					m_lastFrameDisplayTime;
	frame_map_t					m_frameMap;
	uint64_t					m_firstFrameArrivalTime;

	uint64_t					m_hostTimeScale;
	uint64_t					m_displayLinkHostStartTime;
	uint64_t					m_displayLinkStreamStartTime;
}

- (void)enqueueVideoFrame:(CVPixelBufferRef)pixBuf fromNAL:(IBMDStreamingH264NALPacket*)nal;

- (BOOL)getFrameForTime:(const CVTimeStamp*)timeStamp;
- (CVReturn)displayFrame:(const CVTimeStamp*)timeStamp;

- (void)startPlayback;
- (void)stopPlayback;

@end
